"use client"

import React from 'react'
import { 
  MessageSquare, 
  Share2, 
  GitBranch, 
  Zap, 
  Database, 
  Mail,
  PlayCircle
} from 'lucide-react'

const nodeTypes = [
  {
    group: 'Triggers',
    items: [
      { type: 'whatsapp_trigger', label: 'WhatsApp Message', icon: MessageSquare },
      { type: 'social_trigger', label: 'Social Interaction', icon: Share2 },
      { type: 'webhook_trigger', label: 'External Webhook', icon: Zap },
    ]
  },
  {
    group: 'Logic',
    items: [
      { type: 'condition', label: 'If / Else Condition', icon: GitBranch },
      { type: 'delay', label: 'Wait / Delay', icon: PlayCircle },
    ]
  },
  {
    group: 'Actions',
    items: [
      { type: 'whatsapp_reply', label: 'Reply WhatsApp', icon: MessageSquare },
      { type: 'social_reply', label: 'Reply Social', icon: Share2 },
      { type: 'db_store', label: 'Store in Database', icon: Database },
      { type: 'email_send', label: 'Send Email', icon: Mail },
    ]
  }
]

export function FlowSidebar() {
  const onDragStart = (event: React.DragEvent, nodeType: string) => {
    event.dataTransfer.setData('application/reactflow', nodeType)
    event.dataTransfer.effectAllowed = 'move'
  }

  return (
    <aside className="w-64 border-l bg-muted/30 p-4 overflow-y-auto">
      <div className="text-sm font-semibold mb-4">Node Palette</div>
      <div className="space-y-6">
        {nodeTypes.map((group) => (
          <div key={group.group}>
            <div className="text-[10px] uppercase tracking-wider text-muted-foreground font-bold mb-2">
              {group.group}
            </div>
            <div className="space-y-2">
              {group.items.map((item) => (
                <div
                  key={item.type}
                  className="flex items-center gap-3 p-3 bg-background border rounded-lg cursor-grab hover:border-primary/50 transition-colors text-sm shadow-sm"
                  onDragStart={(event) => onDragStart(event, item.type)}
                  draggable
                >
                  <item.icon className="h-4 w-4 text-primary" />
                  {item.label}
                </div>
              ))}
            </div>
          </div>
        ))}
      </div>
      <div className="mt-8 p-4 bg-primary/5 border border-primary/10 rounded-lg text-[11px] text-muted-foreground">
        Drag and drop nodes onto the canvas to build your automation logic.
      </div>
    </aside>
  )
}
