"use client"

import Link from "next/link"
import { usePathname } from "next/navigation"
import { cn } from "@/lib/utils"
import { 
  Bot, 
  LayoutDashboard, 
  MessageSquare, 
  Share2, 
  Zap, 
  History, 
  Settings,
  LogOut,
  ChevronRight
} from "lucide-react"

const sidebarItems = [
  { label: "Dashboard", icon: LayoutDashboard, href: "/dashboard" },
  { label: "WhatsApp Agents", icon: MessageSquare, href: "/dashboard/whatsapp" },
  { label: "Social Media", icon: Share2, href: "/dashboard/social" },
  { label: "Automations", icon: Zap, href: "/dashboard/automations" },
  { label: "Activity Logs", icon: History, href: "/dashboard/logs" },
  { label: "Settings", icon: Settings, href: "/dashboard/settings" },
]

export function Sidebar() {
  const pathname = usePathname()

  return (
    <div className="flex flex-col h-screen w-64 border-r bg-card text-card-foreground fixed left-0 top-0">
      <div className="p-6 flex items-center gap-2 font-bold text-xl text-primary border-b">
        <Bot className="h-6 w-6" />
        <span>SuperAI</span>
      </div>
      
      <nav className="flex-1 overflow-y-auto p-4 space-y-2">
        {sidebarItems.map((item) => (
          <Link
            key={item.href}
            href={item.href}
            className={cn(
              "flex items-center gap-3 px-3 py-2 rounded-lg text-sm font-medium transition-colors hover:bg-secondary/50",
              pathname === item.href ? "bg-primary text-primary-foreground hover:bg-primary/90" : "text-muted-foreground"
            )}
          >
            <item.icon className="h-4 w-4" />
            {item.label}
          </Link>
        ))}
      </nav>

      <div className="p-4 border-t">
        <button className="flex items-center gap-3 px-3 py-2 w-full rounded-lg text-sm font-medium text-destructive hover:bg-destructive/10 transition-colors">
          <LogOut className="h-4 w-4" />
          Logout
        </button>
      </div>
    </div>
  )
}
