"use client"

import Link from "next/link"
import { usePathname } from "next/navigation"
import { cn } from "@/lib/utils"
import { 
  ShieldCheck, 
  Users, 
  Settings, 
  History, 
  LayoutDashboard,
  LogOut,
  ArrowLeft
} from "lucide-react"

const adminItems = [
  { label: "Overview", icon: LayoutDashboard, href: "/admin" },
  { label: "Client Management", icon: Users, href: "/admin/clients" },
  { label: "System Logs", icon: History, href: "/admin/logs" },
  { label: "Global Settings", icon: Settings, href: "/admin/settings" },
]

export function AdminSidebar() {
  const pathname = usePathname()

  return (
    <div className="flex flex-col h-screen w-64 border-r bg-slate-900 text-slate-50 fixed left-0 top-0">
      <div className="p-6 flex items-center gap-2 font-bold text-xl text-blue-400 border-b border-slate-800">
        <ShieldCheck className="h-6 w-6" />
        <span>SuperAI Admin</span>
      </div>
      
      <nav className="flex-1 overflow-y-auto p-4 space-y-2">
        {adminItems.map((item) => (
          <Link
            key={item.href}
            href={item.href}
            className={cn(
              "flex items-center gap-3 px-3 py-2 rounded-lg text-sm font-medium transition-colors hover:bg-slate-800",
              pathname === item.href ? "bg-blue-600 text-white hover:bg-blue-700" : "text-slate-400"
            )}
          >
            <item.icon className="h-4 w-4" />
            {item.label}
          </Link>
        ))}
      </nav>

      <div className="p-4 border-t border-slate-800 space-y-2">
        <Link 
          href="/dashboard"
          className="flex items-center gap-3 px-3 py-2 w-full rounded-lg text-sm font-medium text-slate-400 hover:bg-slate-800 transition-colors"
        >
          <ArrowLeft className="h-4 w-4" />
          Back to Client View
        </Link>
        <button className="flex items-center gap-3 px-3 py-2 w-full rounded-lg text-sm font-medium text-red-400 hover:bg-red-950/30 transition-colors">
          <LogOut className="h-4 w-4" />
          Logout
        </button>
      </div>
    </div>
  )
}
