"use client"

import Link from "next/navigation"
import { motion } from "framer-motion"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { 
  Bot, 
  MessageSquare, 
  Share2, 
  Zap, 
  Shield, 
  BarChart3, 
  ArrowRight,
  CheckCircle2
} from "lucide-react"

export default function LandingPage() {
  return (
    <div className="flex flex-col min-h-screen">
      {/* Navigation */}
      <header className="px-4 lg:px-6 h-16 flex items-center border-b bg-background/95 backdrop-blur supports-[backdrop-filter]:bg-background/60 sticky top-0 z-50">
        <div className="flex items-center gap-2 font-bold text-2xl text-primary">
          <Bot className="h-8 w-8" />
          <span>SuperAI</span>
        </div>
        <nav className="ml-auto flex gap-4 sm:gap-6">
          <a className="text-sm font-medium hover:underline underline-offset-4" href="#features">Features</a>
          <a className="text-sm font-medium hover:underline underline-offset-4" href="#pricing">Pricing</a>
          <a className="text-sm font-medium hover:underline underline-offset-4" href="/login">Login</a>
          <Button asChild size="sm">
            <a href="/register">Get Started</a>
          </Button>
        </nav>
      </header>

      <main className="flex-1">
        {/* Hero Section */}
        <section className="w-full py-12 md:py-24 lg:py-32 xl:py-48 bg-secondary/30">
          <div className="container px-4 md:px-6 mx-auto">
            <div className="flex flex-col items-center space-y-4 text-center">
              <motion.div
                initial={{ opacity: 0, y: 20 }}
                animate={{ opacity: 1, y: 0 }}
                transition={{ duration: 0.5 }}
                className="space-y-2"
              >
                <h1 className="text-3xl font-bold tracking-tighter sm:text-4xl md:text-5xl lg:text-6xl/none">
                  Your Full SaaS <span className="text-primary">AI Agent Platform</span>
                </h1>
                <p className="mx-auto max-w-[700px] text-muted-foreground md:text-xl">
                  Automate your business with WhatsApp AI agents, social media management, and custom workflow automations. Enterprise-ready, multi-tenant, and ready to scale.
                </p>
              </motion.div>
              <motion.div
                initial={{ opacity: 0, scale: 0.9 }}
                animate={{ opacity: 1, scale: 1 }}
                transition={{ duration: 0.5, delay: 0.2 }}
                className="space-x-4"
              >
                <Button size="lg" className="px-8" asChild>
                  <a href="/register">Start Free Trial</a>
                </Button>
                <Button variant="outline" size="lg" className="px-8">
                  View Demo
                </Button>
              </motion.div>
            </div>
          </div>
        </section>

        {/* Features Section */}
        <section id="features" className="w-full py-12 md:py-24 lg:py-32">
          <div className="container px-4 md:px-6 mx-auto">
            <div className="flex flex-col items-center justify-center space-y-4 text-center">
              <div className="space-y-2">
                <div className="inline-block rounded-lg bg-primary/10 px-3 py-1 text-sm text-primary">Core Agents</div>
                <h2 className="text-3xl font-bold tracking-tighter sm:text-5xl">The AI Workforce for Modern Business</h2>
                <p className="max-w-[900px] text-muted-foreground md:text-xl/relaxed lg:text-base/relaxed xl:text-xl/relaxed">
                  SuperAI provides a suite of specialized agents that handle your communication, marketing, and internal operations.
                </p>
              </div>
            </div>
            <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mt-12">
              <Card className="border-primary/10 hover:border-primary/50 transition-colors">
                <CardHeader>
                  <MessageSquare className="h-10 w-10 text-primary mb-2" />
                  <CardTitle>WhatsApp AI Agent</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-muted-foreground">Auto-replies, conversation history, and intelligent flows for all your WhatsApp numbers. Never miss a lead.</p>
                </CardContent>
              </Card>
              <Card className="border-primary/10 hover:border-primary/50 transition-colors">
                <Share2 className="h-10 w-10 text-primary m-6 mb-2" />
                <CardHeader className="pt-0">
                  <CardTitle>Social Media Agent</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-muted-foreground">Unified inbox for all platforms. AI handles comments and direct messages with brand-consistent personality.</p>
                </CardContent>
              </Card>
              <Card className="border-primary/10 hover:border-primary/50 transition-colors">
                <Zap className="h-10 w-10 text-primary m-6 mb-2" />
                <CardHeader className="pt-0">
                  <CardTitle>Workflow Brain</CardTitle>
                </CardHeader>
                <CardContent>
                  <p className="text-muted-foreground">Connect your agents with no-code visual flows. WhatsApp → Database → Email. Pure automation logic.</p>
                </CardContent>
              </Card>
            </div>
          </div>
        </section>

        {/* No-Code Section */}
        <section className="w-full py-12 md:py-24 lg:py-32 bg-secondary/30">
          <div className="container px-4 md:px-6 mx-auto">
            <div className="grid gap-10 lg:grid-cols-2 items-center">
              <div className="space-y-4">
                <h2 className="text-3xl font-bold tracking-tighter sm:text-4xl">Visual No-Code Flow Builder</h2>
                <p className="text-muted-foreground md:text-xl/relaxed">
                  Design complex business logic with our drag-and-drop interface. Create triggers, conditions, and actions that work across all your connected agents.
                </p>
                <ul className="space-y-2">
                  <li className="flex items-center gap-2 font-medium"><CheckCircle2 className="h-5 w-5 text-primary" /> Drag & drop logic elements</li>
                  <li className="flex items-center gap-2 font-medium"><CheckCircle2 className="h-5 w-5 text-primary" /> Multi-agent triggers</li>
                  <li className="flex items-center gap-2 font-medium"><CheckCircle2 className="h-5 w-5 text-primary" /> Real-time activity monitoring</li>
                </ul>
                <Button size="lg" variant="secondary" className="mt-4">Explore Automation</Button>
              </div>
              <div className="relative group overflow-hidden rounded-xl border bg-background p-2 shadow-2xl">
                <img 
                  src="https://images.unsplash.com/photo-1551288049-bbda1825d71c?q=80&w=2070&auto=format&fit=crop" 
                  alt="Flow Builder Dashboard" 
                  className="rounded-lg aspect-video object-cover"
                />
              </div>
            </div>
          </div>
        </section>

        {/* Trust Section */}
        <section className="w-full py-12 md:py-24 lg:py-32">
          <div className="container px-4 md:px-6 mx-auto">
            <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
              <div className="flex flex-col items-center space-y-2 text-center">
                <Shield className="h-10 w-10 text-primary" />
                <h3 className="text-xl font-bold">Secure Multi-tenant</h3>
                <p className="text-sm text-muted-foreground">Isolated data storage for every client with enterprise-grade security.</p>
              </div>
              <div className="flex flex-col items-center space-y-2 text-center">
                <BarChart3 className="h-10 w-10 text-primary" />
                <h3 className="text-xl font-bold">Usage Limits</h3>
                <p className="text-sm text-muted-foreground">Manage plans and limits per client with automated subscription tracking.</p>
              </div>
              <div className="flex flex-col items-center space-y-2 text-center">
                <Bot className="h-10 w-10 text-primary" />
                <h3 className="text-xl font-bold">Custom AI Training</h3>
                <p className="text-sm text-muted-foreground">Fine-tune your agents' behavior to match your brand's unique voice.</p>
              </div>
              <div className="flex flex-col items-center space-y-2 text-center">
                <ArrowRight className="h-10 w-10 text-primary" />
                <h3 className="text-xl font-bold">API Integration</h3>
                <p className="text-sm text-muted-foreground">Ready to connect with your existing tech stack and third-party tools.</p>
              </div>
            </div>
          </div>
        </section>
      </main>

      {/* Footer */}
      <footer className="w-full border-t py-6 bg-background">
        <div className="container px-4 md:px-6 mx-auto flex flex-col md:flex-row justify-between items-center gap-4">
          <div className="flex items-center gap-2 font-bold text-lg">
            <Bot className="h-6 w-6 text-primary" />
            <span>SuperAI</span>
          </div>
          <p className="text-sm text-muted-foreground">© 2026 SuperAI Platform. All rights reserved.</p>
          <div className="flex gap-4">
            <a className="text-sm text-muted-foreground hover:underline underline-offset-4" href="#">Privacy Policy</a>
            <a className="text-sm text-muted-foreground hover:underline underline-offset-4" href="#">Terms of Service</a>
          </div>
        </div>
      </footer>
    </div>
  )
}
