import { createClient } from "@/lib/supabase/server"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { 
  Plus, 
  MessageSquare, 
  Phone, 
  Settings2, 
  History,
  MoreVertical,
  Play,
  Pause
} from "lucide-react"

export default async function WhatsAppPage() {
  const supabase = await createClient()
  const { data: agents } = await supabase
    .from("agents")
    .select("*")
    .eq("type", "whatsapp")

  return (
    <div className="space-y-6">
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-3xl font-bold">WhatsApp Agents</h1>
          <p className="text-muted-foreground">Manage your connected WhatsApp numbers and AI behaviors.</p>
        </div>
        <Button className="gap-2">
          <Plus className="h-4 w-4" />
          Add Number
        </Button>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {agents && agents.length > 0 ? (
          agents.map((agent) => (
            <Card key={agent.id} className="relative overflow-hidden">
              <div className="absolute top-4 right-4">
                <Badge variant={agent.status === 'active' ? 'default' : 'secondary'}>
                  {agent.status}
                </Badge>
              </div>
              <CardHeader className="flex flex-row items-center gap-4">
                <div className="p-2 bg-primary/10 rounded-full">
                  <MessageSquare className="h-6 w-6 text-primary" />
                </div>
                <div>
                  <CardTitle>{agent.name}</CardTitle>
                  <p className="text-xs text-muted-foreground flex items-center gap-1">
                    <Phone className="h-3 w-3" />
                    {agent.config?.phoneNumber || "No number connected"}
                  </p>
                </div>
              </CardHeader>
              <CardContent className="space-y-4">
                <div className="flex gap-2">
                  <Button variant="outline" size="sm" className="flex-1 gap-2">
                    <History className="h-4 w-4" />
                    Logs
                  </Button>
                  <Button variant="outline" size="sm" className="flex-1 gap-2">
                    <Settings2 className="h-4 w-4" />
                    Edit
                  </Button>
                </div>
                <div className="flex gap-2">
                  {agent.status === 'active' ? (
                    <Button variant="secondary" size="sm" className="w-full gap-2">
                      <Pause className="h-4 w-4" />
                      Pause Agent
                    </Button>
                  ) : (
                    <Button variant="default" size="sm" className="w-full gap-2">
                      <Play className="h-4 w-4" />
                      Resume Agent
                    </Button>
                  )}
                </div>
              </CardContent>
            </Card>
          ))
        ) : (
          <Card className="col-span-full py-12">
            <CardContent className="flex flex-col items-center justify-center text-center space-y-4">
              <div className="p-4 bg-muted rounded-full">
                <MessageSquare className="h-12 w-12 text-muted-foreground" />
              </div>
              <div>
                <h3 className="text-lg font-semibold">No WhatsApp agents found</h3>
                <p className="text-muted-foreground">Click the "Add Number" button to connect your first WhatsApp account.</p>
              </div>
              <Button>Connect Now</Button>
            </CardContent>
          </Card>
        )}
      </div>
    </div>
  )
}
