import { createClient } from "@/lib/supabase/server"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { 
  Plus, 
  Share2, 
  Instagram, 
  Facebook, 
  Twitter,
  MessageCircle,
  Settings2,
  Activity
} from "lucide-react"

export default async function SocialPage() {
  const supabase = await createClient()
  const { data: agents } = await supabase
    .from("agents")
    .select("*")
    .eq("type", "social")

  return (
    <div className="space-y-6">
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-3xl font-bold">Social Media Agents</h1>
          <p className="text-muted-foreground">AI management for your social media presence and unified inbox.</p>
        </div>
        <Button className="gap-2">
          <Plus className="h-4 w-4" />
          Connect Platform
        </Button>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        {agents && agents.length > 0 ? (
          agents.map((agent) => (
            <Card key={agent.id}>
              <CardHeader className="flex flex-row items-center justify-between">
                <div className="flex items-center gap-3">
                  <div className="p-2 bg-primary/10 rounded-lg">
                    {agent.config?.platform === 'instagram' ? <Instagram className="h-5 w-5 text-pink-600" /> : 
                     agent.config?.platform === 'facebook' ? <Facebook className="h-5 w-5 text-blue-600" /> : 
                     <Share2 className="h-5 w-5 text-primary" />}
                  </div>
                  <div>
                    <CardTitle className="text-lg">{agent.name}</CardTitle>
                    <p className="text-xs text-muted-foreground capitalize">{agent.config?.platform || 'Social'}</p>
                  </div>
                </div>
                <Badge variant={agent.status === 'active' ? 'default' : 'secondary'}>
                  {agent.status}
                </Badge>
              </CardHeader>
              <CardContent className="space-y-4">
                <div className="grid grid-cols-2 gap-2 text-center">
                  <div className="p-2 bg-secondary/50 rounded-lg">
                    <p className="text-xs text-muted-foreground">Comments</p>
                    <p className="text-lg font-bold">142</p>
                  </div>
                  <div className="p-2 bg-secondary/50 rounded-lg">
                    <p className="text-xs text-muted-foreground">DMs</p>
                    <p className="text-lg font-bold">58</p>
                  </div>
                </div>
                <div className="flex gap-2">
                  <Button variant="outline" size="sm" className="w-full gap-2">
                    <MessageCircle className="h-4 w-4" />
                    Inbox
                  </Button>
                  <Button variant="outline" size="sm" className="w-full gap-2">
                    <Settings2 className="h-4 w-4" />
                    Config
                  </Button>
                </div>
              </CardContent>
            </Card>
          ))
        ) : (
          <Card className="col-span-full py-12">
            <CardContent className="flex flex-col items-center justify-center text-center space-y-4">
              <div className="p-4 bg-muted rounded-full">
                <Share2 className="h-12 w-12 text-muted-foreground" />
              </div>
              <div>
                <h3 className="text-lg font-semibold">No social agents connected</h3>
                <p className="text-muted-foreground">Connect your Instagram, Facebook, or Twitter accounts to enable AI auto-replies.</p>
              </div>
              <Button>Connect Account</Button>
            </CardContent>
          </Card>
        )}
      </div>
    </div>
  )
}
