import { createClient } from "@/lib/supabase/server"
import { Button } from "@/components/ui/button"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { Badge } from "@/components/ui/badge"
import { 
  Plus, 
  Zap, 
  Play, 
  Settings2, 
  GitBranch,
  Calendar,
  MoreVertical
} from "lucide-react"

export default async function AutomationsPage() {
  const supabase = await createClient()
  const { data: automations } = await supabase
    .from("automations")
    .select("*")

  return (
    <div className="space-y-6">
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-3xl font-bold">Workflows & Automations</h1>
          <p className="text-muted-foreground">The central brain connecting your agents and business logic.</p>
        </div>
        <Button className="gap-2">
          <Plus className="h-4 w-4" />
          Create Workflow
        </Button>
      </div>

      <div className="grid grid-cols-1 gap-4">
        {automations && automations.length > 0 ? (
          automations.map((flow) => (
            <Card key={flow.id} className="hover:border-primary/50 transition-colors">
              <CardContent className="flex items-center justify-between p-6">
                <div className="flex items-center gap-4">
                  <div className="p-3 bg-primary/10 rounded-lg">
                    <Zap className="h-6 w-6 text-primary" />
                  </div>
                  <div>
                    <CardTitle className="text-lg">{flow.name}</CardTitle>
                    <div className="flex items-center gap-3 mt-1 text-sm text-muted-foreground">
                      <span className="flex items-center gap-1">
                        <GitBranch className="h-3 w-3" />
                        {flow.flow_data?.nodes?.length || 0} nodes
                      </span>
                      <span className="flex items-center gap-1">
                        <Calendar className="h-3 w-3" />
                        Updated {new Date(flow.created_at).toLocaleDateString()}
                      </span>
                    </div>
                  </div>
                </div>
                <div className="flex items-center gap-4">
                  <Badge variant={flow.is_active ? 'default' : 'secondary'}>
                    {flow.is_active ? 'Running' : 'Paused'}
                  </Badge>
                  <div className="flex gap-2">
                    <Button variant="outline" size="sm">Edit Flow</Button>
                    <Button variant="outline" size="icon" size="sm">
                      <MoreVertical className="h-4 w-4" />
                    </Button>
                  </div>
                </div>
              </CardContent>
            </Card>
          ))
        ) : (
          <Card className="py-12">
            <CardContent className="flex flex-col items-center justify-center text-center space-y-4">
              <div className="p-4 bg-muted rounded-full">
                <Zap className="h-12 w-12 text-muted-foreground" />
              </div>
              <div>
                <h3 className="text-lg font-semibold">No workflows found</h3>
                <p className="text-muted-foreground">Start by creating a visual flow to automate your business processes.</p>
              </div>
              <Button>Create Your First Flow</Button>
            </CardContent>
          </Card>
        )}
      </div>
    </div>
  )
}
