import { FlowBuilder } from "@/components/flow/FlowBuilder"
import { Button } from "@/components/ui/button"
import { ChevronLeft } from "lucide-react"

export default function BuilderPage() {
  return (
    <div className="h-full flex flex-col space-y-4">
      <div className="flex items-center justify-between">
        <div className="flex items-center gap-4">
          <Button variant="ghost" size="icon" asChild>
            <a href="/dashboard/automations">
              <ChevronLeft className="h-5 w-5" />
            </a>
          </Button>
          <div>
            <h1 className="text-2xl font-bold">New Workflow</h1>
            <p className="text-sm text-muted-foreground">Designing automation logic for SuperAI</p>
          </div>
        </div>
      </div>

      <FlowBuilder />
    </div>
  )
}
