"use server"

import { createClient } from "@/lib/supabase/server"
import { redirect } from "next/navigation"

export async function signUp(formData: FormData) {
  const email = formData.get("email") as string
  const password = formData.get("password") as string
  const fullName = formData.get("fullName") as string
  const orgName = formData.get("orgName") as string

  const supabase = await createClient()

  // 1. Sign up user
  const { data: authData, error: authError } = await supabase.auth.signUp({
    email,
    password,
    options: {
      data: {
        full_name: fullName,
      },
    },
  })

  if (authError) {
    return { error: authError.message }
  }

  if (!authData.user) {
    return { error: "Failed to create user" }
  }

  // 2. Create Organization
  const { data: orgData, error: orgError } = await supabase
    .from("organizations")
    .insert({ name: orgName })
    .select()
    .single()

  if (orgError) {
    return { error: orgError.message }
  }

  // 3. Update Profile (created via trigger or manual insert if trigger not setup)
  // Since I didn't setup the trigger in the SQL tool (I should have), I'll do it manually here.
  const { error: profileError } = await supabase
    .from("profiles")
    .insert({
      id: authData.user.id,
      full_name: fullName,
      email: email,
      organization_id: orgData.id,
      role: 'client'
    })

  if (profileError) {
     // If profile already exists (e.g. from trigger), update it
     await supabase
      .from("profiles")
      .update({ organization_id: orgData.id })
      .eq('id', authData.user.id)
  }

  return { success: true }
}
