import { createClient } from "@/lib/supabase/server"
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card"
import { 
  Users, 
  Building2, 
  Activity, 
  ShieldAlert,
  TrendingUp,
  DollarSign
} from "lucide-react"

export default async function AdminOverviewPage() {
  const supabase = await createClient()

  const { count: clientCount } = await supabase
    .from("organizations")
    .select("*", { count: 'exact', head: true })

  const { count: userCount } = await supabase
    .from("profiles")
    .select("*", { count: 'exact', head: true })

  const { count: agentCount } = await supabase
    .from("agents")
    .select("*", { count: 'exact', head: true })

  return (
    <div className="space-y-8">
      <div>
        <h1 className="text-3xl font-bold">System Administration</h1>
        <p className="text-muted-foreground">Monitor and manage the SuperAI SaaS platform at scale.</p>
      </div>

      <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
        <Card>
          <CardHeader className="flex flex-row items-center justify-between pb-2 space-y-0">
            <CardTitle className="text-sm font-medium">Total Clients</CardTitle>
            <Building2 className="h-4 w-4 text-blue-500" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold">{clientCount || 0}</div>
            <p className="text-xs text-muted-foreground">Active organizations</p>
          </CardContent>
        </Card>
        <Card>
          <CardHeader className="flex flex-row items-center justify-between pb-2 space-y-0">
            <CardTitle className="text-sm font-medium">Total Users</CardTitle>
            <Users className="h-4 w-4 text-blue-500" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold">{userCount || 0}</div>
            <p className="text-xs text-muted-foreground">Registered accounts</p>
          </CardContent>
        </Card>
        <Card>
          <CardHeader className="flex flex-row items-center justify-between pb-2 space-y-0">
            <CardTitle className="text-sm font-medium">System Agents</CardTitle>
            <Activity className="h-4 w-4 text-blue-500" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold">{agentCount || 0}</div>
            <p className="text-xs text-muted-foreground">Running across all tenants</p>
          </CardContent>
        </Card>
        <Card>
          <CardHeader className="flex flex-row items-center justify-between pb-2 space-y-0">
            <CardTitle className="text-sm font-medium">Platform Revenue</CardTitle>
            <DollarSign className="h-4 w-4 text-green-500" />
          </CardHeader>
          <CardContent>
            <div className="text-2xl font-bold">$4,290</div>
            <p className="text-xs text-green-500">+18% this month</p>
          </CardContent>
        </Card>
      </div>

      <div className="grid grid-cols-1 lg:grid-cols-3 gap-6">
        <Card className="lg:col-span-2">
          <CardHeader>
            <CardTitle>Global Activity Trend</CardTitle>
          </CardHeader>
          <CardContent className="h-[300px] flex items-center justify-center border-2 border-dashed rounded-lg">
            <TrendingUp className="h-12 w-12 text-muted-foreground/30" />
            <span className="ml-2 text-muted-foreground">Platform usage chart goes here</span>
          </CardContent>
        </Card>

        <Card>
          <CardHeader>
            <CardTitle className="flex items-center gap-2">
              <ShieldAlert className="h-5 w-5 text-red-500" />
              Critical Alerts
            </CardTitle>
          </CardHeader>
          <CardContent>
            <div className="space-y-4">
              <div className="p-3 bg-red-50 border border-red-100 rounded-lg">
                <p className="text-sm font-medium text-red-900">WhatsApp Gateway Timeout</p>
                <p className="text-xs text-red-700 mt-1">Number +1234567890 disconnected (Acme Inc)</p>
              </div>
              <div className="p-3 bg-yellow-50 border border-yellow-100 rounded-lg">
                <p className="text-sm font-medium text-yellow-900">High API Usage</p>
                <p className="text-xs text-yellow-700 mt-1">Client "Global Tech" reaching 90% of limit</p>
              </div>
            </div>
          </CardContent>
        </Card>
      </div>
    </div>
  )
}
