'use client';

import React from 'react';
import Link from 'next/link';
import { usePathname } from 'next/navigation';
import { useLanguage } from '@/components/LanguageProvider';
import { 
  LayoutDashboard, 
  MessageSquare, 
  Share2, 
  Database, 
  Users, 
  Zap, 
  BarChart3, 
  Settings, 
  Languages 
} from 'lucide-react';
import { cn } from '@/lib/utils';
import { Button } from '@/components/ui/button';

export function Sidebar() {
  const pathname = usePathname();
  const { t, language, setLanguage, isRtl } = useLanguage();

  const menuItems = [
    { name: t('dashboard'), icon: LayoutDashboard, href: '/' },
    { name: t('inbox'), icon: MessageSquare, href: '/inbox' },
    { name: t('channels'), icon: Share2, href: '/channels' },
    { name: t('knowledge'), icon: Database, href: '/knowledge' },
    { name: t('crm'), icon: Users, href: '/crm' },
    { name: t('automation'), icon: Zap, href: '/automation' },
    { name: t('analytics'), icon: BarChart3, href: '/analytics' },
    { name: t('settings'), icon: Settings, href: '/settings' },
  ];

  return (
    <aside className={cn(
      "fixed inset-y-0 flex w-64 flex-col border-zinc-200 bg-white dark:border-zinc-800 dark:bg-zinc-900 transition-all duration-300 z-50",
      isRtl ? "right-0 border-l" : "left-0 border-r"
    )}>
        <div className="flex h-16 items-center border-b px-6 border-zinc-200 dark:border-zinc-800">
          <span className="text-lg font-bold text-zinc-900 dark:text-white truncate">Super Agent - متجر سر الاناقه</span>
        </div>
      
      <nav className="flex-1 space-y-1 px-3 py-4">
        {menuItems.map((item) => {
          const isActive = pathname === item.href;
          return (
            <Link
              key={item.href}
              href={item.href}
              className={cn(
                "group flex items-center rounded-md px-3 py-2 text-sm font-medium transition-colors",
                isActive 
                  ? "bg-zinc-100 text-zinc-900 dark:bg-zinc-800 dark:text-white" 
                  : "text-zinc-600 hover:bg-zinc-50 hover:text-zinc-900 dark:text-zinc-400 dark:hover:bg-zinc-800 dark:hover:text-white"
              )}
            >
              <item.icon className={cn(
                "h-5 w-5 shrink-0",
                isRtl ? "ml-3" : "mr-3",
                isActive ? "text-zinc-900 dark:text-white" : "text-zinc-400 group-hover:text-zinc-900 dark:group-hover:text-white"
              )} />
              {item.name}
            </Link>
          );
        })}
      </nav>

      <div className="border-t border-zinc-200 p-4 dark:border-zinc-800">
        <Button
          variant="ghost"
          className="w-full justify-start text-zinc-600 dark:text-zinc-400"
          onClick={() => setLanguage(language === 'en' ? 'ar' : 'en')}
        >
          <Languages className={cn("h-5 w-5 shrink-0", isRtl ? "ml-3" : "mr-3")} />
          {t('language')}: {language === 'en' ? t('english') : t('arabic')}
        </Button>
      </div>
    </aside>
  );
}
