'use client';

import React from 'react';
import { Sidebar } from '@/components/Sidebar';
import { useLanguage } from '@/components/LanguageProvider';
import { cn } from '@/lib/utils';

export function DashboardLayout({ children }: { children: React.ReactNode }) {
  const { isRtl } = useLanguage();

  return (
    <div className="flex min-h-screen">
      <Sidebar />
      <main className={cn(
        "flex-1 transition-all duration-300",
        isRtl ? "pr-64" : "pl-64"
      )}>
        <div className="p-8">
          {children}
        </div>
      </main>
    </div>
  );
}
