'use client';

import { DashboardLayout } from "@/components/DashboardLayout";
import { useLanguage } from "@/components/LanguageProvider";
import { Card, CardContent, CardHeader, CardTitle } from "@/components/ui/card";
import { 
  MessageSquare, 
  Share2, 
  Users, 
  Zap, 
  BarChart3 
} from "lucide-react";

export default function Home() {
  const { t } = useLanguage();

  const stats = [
    { title: t('whatsapp'), value: "3", icon: MessageSquare, color: "text-green-500" },
    { title: t('facebook'), value: "1", icon: Share2, color: "text-blue-500" },
    { title: t('instagram'), value: "2", icon: Share2, color: "text-pink-500" },
    { title: t('contacts'), value: "1,284", icon: Users, color: "text-purple-500" },
  ];

  return (
    <DashboardLayout>
      <div className="space-y-8">
        <div>
          <h1 className="text-3xl font-bold tracking-tight text-zinc-900 dark:text-white">
            {t('dashboard')}
          </h1>
          <p className="text-zinc-500 dark:text-zinc-400">
            Welcome back to Super Agent - متجر سر الاناقه.
          </p>
        </div>

        <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
          {stats.map((stat) => (
            <Card key={stat.title}>
              <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                <CardTitle className="text-sm font-medium">
                  {stat.title}
                </CardTitle>
                <stat.icon className={`h-4 w-4 ${stat.color}`} />
              </CardHeader>
              <CardContent>
                <div className="text-2xl font-bold">{stat.value}</div>
              </CardContent>
            </Card>
          ))}
        </div>

        <div className="grid gap-4 md:grid-cols-2">
          <Card className="col-span-1">
            <CardHeader>
              <CardTitle>{t('analytics')}</CardTitle>
            </CardHeader>
            <CardContent className="h-[300px] flex items-center justify-center text-zinc-400">
              <BarChart3 className="h-12 w-12 mr-2" />
              Chart Placeholder
            </CardContent>
          </Card>
          <Card className="col-span-1">
            <CardHeader>
              <CardTitle>{t('automation')}</CardTitle>
            </CardHeader>
            <CardContent className="h-[300px] flex items-center justify-center text-zinc-400">
              <Zap className="h-12 w-12 mr-2" />
              Automation Activity
            </CardContent>
          </Card>
        </div>
      </div>
    </DashboardLayout>
  );
}
