'use client';

import React from 'react';
import { DashboardLayout } from "@/components/DashboardLayout";
import { useLanguage } from "@/components/LanguageProvider";
import { Card, CardContent, CardHeader, CardTitle, CardDescription } from "@/components/ui/card";
import { 
  BarChart, 
  Bar, 
  XAxis, 
  YAxis, 
  CartesianGrid, 
  Tooltip, 
  ResponsiveContainer,
  LineChart,
  Line,
  PieChart,
  Pie,
  Cell
} from 'recharts';
import { 
  MessageSquare, 
  Bot, 
  Clock, 
  Zap,
  Download
} from "lucide-react";
import { Button } from "@/components/ui/button";

const data = [
  { name: 'Mon', whatsapp: 400, facebook: 240, instagram: 240 },
  { name: 'Tue', whatsapp: 300, facebook: 139, instagram: 221 },
  { name: 'Wed', whatsapp: 200, facebook: 980, instagram: 229 },
  { name: 'Thu', whatsapp: 278, facebook: 390, instagram: 200 },
  { name: 'Fri', whatsapp: 189, facebook: 480, instagram: 218 },
  { name: 'Sat', whatsapp: 239, facebook: 380, instagram: 250 },
  { name: 'Sun', whatsapp: 349, facebook: 430, instagram: 210 },
];

const sourceData = [
  { name: 'WhatsApp', value: 400, color: '#22c55e' },
  { name: 'Facebook', value: 300, color: '#2563eb' },
  { name: 'Instagram', value: 300, color: '#ec4899' },
];

export default function AnalyticsPage() {
  const { t } = useLanguage();

  return (
    <DashboardLayout>
      <div className="space-y-6">
        <div className="flex items-center justify-between">
          <div>
            <h1 className="text-3xl font-bold tracking-tight text-zinc-900 dark:text-white">
              {t('analytics')}
            </h1>
            <p className="text-zinc-500 dark:text-zinc-400">
              Track your performance across all AI agents and channels.
            </p>
          </div>
            <Button variant="outline">
              <Download className="mr-2 h-4 w-4" />
              {t('exportReport')}
            </Button>
          </div>
  
          <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-4">
            <Card>
              <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                <CardTitle className="text-sm font-medium">{t('totalMessages')}</CardTitle>
                <MessageSquare className="h-4 w-4 text-zinc-400" />
              </CardHeader>
              <CardContent>
                <div className="text-2xl font-bold">12,482</div>
                <p className="text-xs text-zinc-500">+12% from last week</p>
              </CardContent>
            </Card>
            <Card>
              <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                <CardTitle className="text-sm font-medium">{t('aiResponses')}</CardTitle>
                <Bot className="h-4 w-4 text-zinc-400" />
              </CardHeader>
              <CardContent>
                <div className="text-2xl font-bold">8,294</div>
                <p className="text-xs text-zinc-500">66.4% automation rate</p>
              </CardContent>
            </Card>
            <Card>
              <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                <CardTitle className="text-sm font-medium">{t('avgResponseTime')}</CardTitle>
                <Clock className="h-4 w-4 text-zinc-400" />
              </CardHeader>
              <CardContent>
                <div className="text-2xl font-bold">1.2s</div>
                <p className="text-xs text-zinc-500">-0.4s from last month</p>
              </CardContent>
            </Card>
            <Card>
              <CardHeader className="flex flex-row items-center justify-between space-y-0 pb-2">
                <CardTitle className="text-sm font-medium">{t('automationsRun')}</CardTitle>
                <Zap className="h-4 w-4 text-zinc-400" />
              </CardHeader>
              <CardContent>
                <div className="text-2xl font-bold">4,120</div>
                <p className="text-xs text-zinc-500">98% success rate</p>
              </CardContent>
            </Card>
          </div>
  
          <div className="grid gap-4 md:grid-cols-2 lg:grid-cols-7">
            <Card className="col-span-4">
              <CardHeader>
                <CardTitle>{t('activityByChannel')}</CardTitle>
                <CardDescription>Number of messages received per day.</CardDescription>
              </CardHeader>
              <CardContent className="h-[400px]">
                <ResponsiveContainer width="100%" height="100%">
                  <BarChart data={data}>
                    <CartesianGrid strokeDasharray="3 3" vertical={false} />
                    <XAxis dataKey="name" />
                    <YAxis />
                    <Tooltip 
                      contentStyle={{ borderRadius: '12px', border: 'none', boxShadow: '0 4px 12px rgba(0,0,0,0.1)' }}
                    />
                    <Bar dataKey="whatsapp" name={t('whatsapp')} fill="#22c55e" radius={[4, 4, 0, 0]} />
                    <Bar dataKey="facebook" name={t('facebook')} fill="#2563eb" radius={[4, 4, 0, 0]} />
                    <Bar dataKey="instagram" name={t('instagram')} fill="#ec4899" radius={[4, 4, 0, 0]} />
                  </BarChart>
                </ResponsiveContainer>
              </CardContent>
            </Card>
  
            <Card className="col-span-3">
              <CardHeader>
                <CardTitle>{t('sourceDistribution')}</CardTitle>
                <CardDescription>Where your customers are messaging from.</CardDescription>
              </CardHeader>
              <CardContent className="h-[400px] flex flex-col items-center justify-center">
                <ResponsiveContainer width="100%" height="80%">
                  <PieChart>
                    <Pie
                      data={sourceData}
                      cx="50%"
                      cy="50%"
                      innerRadius={60}
                      outerRadius={80}
                      paddingAngle={5}
                      dataKey="value"
                    >
                      {sourceData.map((entry, index) => (
                        <Cell key={`cell-${index}`} fill={entry.color} />
                      ))}
                    </Pie>
                    <Tooltip />
                  </PieChart>
                </ResponsiveContainer>
                <div className="mt-4 grid grid-cols-3 gap-4 text-center">
                  {sourceData.map((item) => (
                    <div key={item.name}>
                      <div className="text-sm font-semibold">{item.value}</div>
                      <div className="text-[10px] text-zinc-500 uppercase">{item.name}</div>
                    </div>
                  ))}
                </div>
              </CardContent>
            </Card>
          </div>

      </div>
    </DashboardLayout>
  );
}
