# AI Multi-Channel Agent Platform - cPanel Deployment

## Build for cPanel Shared Hosting

1. **Build the project locally:**
   ```bash
   npm install
   npm run build
   ```

2. **Upload to cPanel:**
   - The build creates an `out/` folder with static HTML files
   - Upload ALL contents of `out/` folder to your `public_html` directory (or subdomain folder)

3. **Create `.htaccess` in `public_html`:**
   ```apache
   <IfModule mod_rewrite.c>
     RewriteEngine On
     RewriteBase /
     
     # Handle trailing slashes
     RewriteCond %{REQUEST_FILENAME} !-f
     RewriteCond %{REQUEST_FILENAME} !-d
     RewriteCond %{REQUEST_URI} !/$
     RewriteRule ^(.*)$ %{REQUEST_URI}/ [L,R=301]
     
     # Serve index.html for directories
     RewriteCond %{REQUEST_FILENAME} -d
     RewriteCond %{REQUEST_FILENAME}/index.html -f
     RewriteRule ^(.*)$ $1/index.html [L]
   </IfModule>
   
   # Enable CORS for Supabase
   <IfModule mod_headers.c>
     Header set Access-Control-Allow-Origin "*"
   </IfModule>
   ```

## Environment Variables

The Supabase credentials are embedded in the static build. For production, update `src/lib/supabase.ts` with your production keys before building.

## File Structure After Build

```
public_html/
├── index.html
├── analytics/
│   └── index.html
├── automation/
│   └── index.html
├── channels/
│   └── index.html
├── crm/
│   └── index.html
├── inbox/
│   └── index.html
├── knowledge/
│   └── index.html
├── settings/
│   └── index.html
├── _next/
│   └── static/
└── .htaccess
```

## Notes

- This is a **static export** - all pages are pre-rendered HTML
- Database operations use Supabase client-side SDK (works from any static host)
- No server-side Node.js required
- All API calls go directly to Supabase from the browser
